/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.immortalers_delight.client.particle;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.renyigesai.immortalers_delight.client.model.projectile.HugeSmokeParticleModel;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class HugeSmokeParticle
extends Particle {
    private static final ResourceLocation TEXTURE_LOCATION = new ResourceLocation("immortalers_delight", "textures/particle/huge_smoke.png");
    private static final ResourceLocation LAYER_TEXTURE_LOCATION = new ResourceLocation("immortalers_delight", "textures/particle/huge_smoke_layer.png");
    private final HugeSmokeParticleModel<?> model;
    protected float quadSize;
    protected float layer_rCol;
    protected float layer_gCol;
    protected float layer_bCol;
    protected float layer_alpha;
    protected float xRot;
    protected float yRot;
    protected float zRot;
    protected float layer_xRot;
    protected float layer_yRot;
    protected float layer_zRot;

    public static HugeSmokeParticleProvider baseSmokeProvider(SpriteSet spriteSet) {
        return new HugeSmokeParticleProvider(spriteSet);
    }

    HugeSmokeParticle(ClientLevel pLevel, double pX, double pY, double pZ) {
        super(pLevel, pX, pY, pZ);
        this.quadSize = 1.0f + (this.f_107223_.m_188501_() * 0.5f + (float)(this.f_107223_.m_188499_() ? 1 : -1) * 0.5f) * 0.2f;
        this.layer_rCol = 1.0f;
        this.layer_gCol = 1.0f;
        this.layer_bCol = 1.0f;
        this.layer_alpha = 1.0f;
        this.xRot = 0.0f;
        this.yRot = 0.0f;
        this.zRot = 0.0f;
        this.layer_xRot = 0.0f;
        this.layer_yRot = 0.0f;
        this.layer_zRot = 0.0f;
        this.model = new HugeSmokeParticleModel(Minecraft.m_91087_().m_167973_().m_171103_(HugeSmokeParticleModel.HUGE_SMOKE_PARTICLE));
        this.f_107226_ = -(0.005f + (float)this.f_107223_.m_188503_(2) * 0.001f);
        this.f_107225_ = 60 + this.f_107223_.m_188503_(12);
    }

    @NotNull
    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107433_;
    }

    protected void setLayerAlpha(float pAlpha) {
        this.layer_alpha = pAlpha;
    }

    public void m_5989_() {
        super.m_5989_();
        this.doOnTick();
    }

    protected void doOnTick() {
        this.f_107228_ *= 0.96f;
        this.f_107229_ *= 0.9f;
        if (this.f_107224_ == 1) {
            float f = this.f_107223_.m_188501_();
            boolean flag = this.f_107223_.m_188499_();
            this.layer_yRot = this.yRot = (this.quadSize - 1.0f) * 5.0f * f;
            if (flag) {
                this.layer_xRot = this.xRot = (this.quadSize - 1.0f) * 5.0f * (1.0f - f);
            } else {
                this.layer_zRot = this.zRot = (this.quadSize - 1.0f) * 5.0f * (1.0f - f);
            }
        }
    }

    public void m_5744_(VertexConsumer pBuffer, Camera pRenderInfo, float pPartialTicks) {
        VertexConsumer vertexconsumer;
        Vec3 cameraPos = pRenderInfo.m_90583_();
        double particleX = Mth.m_14139_((double)pPartialTicks, (double)this.f_107209_, (double)this.f_107212_);
        double particleY = Mth.m_14139_((double)pPartialTicks, (double)this.f_107210_, (double)this.f_107213_);
        double particleZ = Mth.m_14139_((double)pPartialTicks, (double)this.f_107211_, (double)this.f_107214_);
        double relX = particleX - cameraPos.m_7096_();
        double relY = particleY - cameraPos.m_7098_();
        double relZ = particleZ - cameraPos.m_7094_();
        PoseStack posestack = new PoseStack();
        posestack.m_85837_(relX, relY, relZ);
        posestack.m_85841_(-1.0f, -1.0f, 1.0f);
        float zoom = this.getQuadSize(pPartialTicks);
        posestack.m_85841_(zoom, zoom, zoom);
        posestack.m_252880_(0.0f, -zoom, 0.0f);
        this.doOnRender(pBuffer, pRenderInfo, pPartialTicks);
        MultiBufferSource.BufferSource multibuffersource$buffersource = Minecraft.m_91087_().m_91269_().m_110104_();
        if (this.needCoreRender(pBuffer, pRenderInfo, pPartialTicks)) {
            this.coreAnim(pBuffer, pRenderInfo, pPartialTicks);
            this.LayerAnim(pBuffer, pRenderInfo, pPartialTicks);
            vertexconsumer = multibuffersource$buffersource.m_6299_(RenderType.m_110473_((ResourceLocation)this.getTextureLocation(pBuffer, pRenderInfo, pPartialTicks)));
            this.model.m_7695_(posestack, vertexconsumer, 0xF000F0, OverlayTexture.f_118083_, this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_);
        }
        if (this.needLayerRender(pBuffer, pRenderInfo, pPartialTicks)) {
            this.coreAnim(pBuffer, pRenderInfo, pPartialTicks);
            this.LayerAnim(pBuffer, pRenderInfo, pPartialTicks);
            vertexconsumer = multibuffersource$buffersource.m_6299_(RenderType.m_110473_((ResourceLocation)this.getLayerTextureLocation(pBuffer, pRenderInfo, pPartialTicks)));
            this.model.m_7695_(posestack, vertexconsumer, 0xF000F0, OverlayTexture.f_118083_, this.layer_rCol, this.layer_gCol, this.layer_bCol, this.layer_alpha);
        }
        multibuffersource$buffersource.m_109911_();
    }

    public float getQuadSize(float pScaleFactor) {
        float f = ((float)this.f_107224_ + pScaleFactor) / (float)this.f_107225_;
        if (this.f_107224_ <= 5) {
            float f1 = this.f_107224_ / 5;
            float f2 = this.quadSize * (f1 * f * 10.0f * (float)this.f_107225_ / 64.0f);
            return f2 > 1.0f ? 1.0f : f2;
        }
        return this.quadSize + 0.5f * Mth.m_14031_((float)((f - 0.05f) * 0.5f * (float)Math.PI));
    }

    protected void doOnRender(VertexConsumer pBuffer, Camera pRenderInfo, float pPartialTicks) {
        float f = ((float)this.f_107224_ + pPartialTicks) / (float)this.f_107225_;
        float f1 = 0.05f;
        f1 = f < 0.5f ? (f1 += 0.8f) : (f1 += (f <= 0.5f ? 0.0f : 0.3f) + 0.5f * Mth.m_14031_((float)(f * (float)Math.PI)));
        this.m_107271_(f1);
    }

    protected void coreAnim(VertexConsumer pBuffer, Camera pRenderInfo, float pPartialTicks) {
        this.model.getCore().f_104203_ = this.xRot;
        this.model.getCore().f_104204_ = this.yRot;
        this.model.getCore().f_104205_ = this.zRot;
    }

    protected void LayerAnim(VertexConsumer pBuffer, Camera pRenderInfo, float pPartialTicks) {
        this.model.getLayer().f_104203_ = this.layer_xRot;
        this.model.getLayer().f_104204_ = this.layer_yRot;
        this.model.getLayer().f_104205_ = this.layer_zRot;
    }

    protected boolean needCoreRender(VertexConsumer pBuffer, Camera pRenderInfo, float pPartialTicks) {
        return this.f_107230_ >= 0.1f;
    }

    protected boolean needLayerRender(VertexConsumer pBuffer, Camera pRenderInfo, float pPartialTicks) {
        return false;
    }

    public ResourceLocation getTextureLocation(VertexConsumer pBuffer, Camera pRenderInfo, float pPartialTicks) {
        float f = ((float)this.f_107224_ + pPartialTicks) / (float)this.f_107225_;
        if (f < 0.5f) {
            return TEXTURE_LOCATION;
        }
        return LAYER_TEXTURE_LOCATION;
    }

    public ResourceLocation getLayerTextureLocation(VertexConsumer pBuffer, Camera pRenderInfo, float pPartialTicks) {
        return LAYER_TEXTURE_LOCATION;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class HugeSmokeParticleProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public HugeSmokeParticleProvider(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        public Particle createParticle(SimpleParticleType pType, ClientLevel pLevel, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed) {
            return new HugeSmokeParticle(pLevel, pX, pY, pZ);
        }
    }
}

